/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockStepDialog;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepAttachmentsTableModel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.table.VWExpandButtonEditor;
import filenet.vw.toolkit.utils.table.VWExpandButtonRenderer;
import filenet.vw.toolkit.utils.table.VWFieldNameRenderer;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWStepAttachmentsPanel
extends VWStepPropTabPanel
implements MouseListener,
IVWPropertyChangeListener {
    private JScrollPane m_tablePanel = null;
    private VWTable m_attachmentsTable = null;
    private boolean m_bTableAdjusted = false;
    private VWStepAttachmentsTableModel m_attachmentsTableModel = null;
    private AbstractButton m_openBtn = null;
    private AbstractButton m_itemPropBtn = null;
    private AbstractButton m_attachPropBtn = null;
    private AbstractButton m_addBtn = null;
    private AbstractButton m_deleteBtn = null;
    private AbstractButton m_unassignBtn = null;
    private AbstractButton m_assignBtn = null;
    private AbstractButton m_detailsBtn = null;
    private JPopupMenu m_popup = null;
    private JMenuItem m_miOpen = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_open));
    private JMenuItem m_miItemProp = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_assignedItemProperties));
    private JMenuItem m_miAttachProp = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_attachmentProperties));
    private JMenuItem m_miAdd = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_add));
    private JMenuItem m_miDelete = new JMenuItem(VWResource.s_delete);
    private JMenuItem m_miUnassign = new JMenuItem(VWResource.s_unassign);
    private JMenuItem m_miAssign = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_assign));
    private JMenuItem m_miDetails = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_details));
    private ActionListener m_assignActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performAssignAttachment();
        }
    };
    private ActionListener m_unassignActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performUnassignAttachment();
        }
    };
    private ActionListener m_addActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performAddAttachment();
        }
    };
    private ActionListener m_deleteActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performDeleteAttachment();
        }
    };
    private ActionListener m_openActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performOpenAttachment();
        }
    };
    private ActionListener m_itemPropActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performAssignedItemProperties();
        }
    };
    private ActionListener m_attachPropActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performAttachmentProperties();
        }
    };
    private ActionListener m_detailsActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            VWStepAttachmentsPanel.this.performDetails();
        }
    };
    private VWLockStepDialog m_lockStepDlg = null;
    private VWExpandButtonRenderer m_expandBtnRenderer = new VWExpandButtonRenderer();
    private VWExpandButtonEditor m_expandBtnEditor = new VWExpandButtonEditor(new JButton());
    private VWFieldNameRenderer m_fieldNameRenderer = new VWFieldNameRenderer();
    private VWFieldsCellRenderer m_fieldsCellRenderer = new VWFieldsCellRenderer();
    private VWFieldsCellEditor m_fieldsCellEditor = null;
    private JPanel m_buttonPanel = new JPanel();
    private int m_editRow = -1;
    private int m_editCol = -1;
    private MouseEvent m_editEvent = null;

    public VWStepAttachmentsPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 2;
        this.m_attachmentsTableModel = new VWStepAttachmentsTableModel(this.m_parentFrame);
        this.m_fieldsCellEditor = new VWFieldsCellEditor(this.m_parentFrame);
        this.preSetupLayout();
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        if (this.m_attachmentsTableModel == null) {
            this.m_attachmentsTableModel = new VWStepAttachmentsTableModel(this.m_parentFrame);
        }
        if (this.m_stepOccurrence != null) {
            if (this.m_bStepView) {
                this.m_attachmentsTableModel.setData(this.m_stepOccurrence, true);
            } else if (this.m_participant != null) {
                this.m_attachmentsTableModel.setData(this.m_participant, true);
            } else {
                this.m_attachmentsTableModel.setData((VWTrkStepOccurrence)null, true);
            }
        } else {
            this.m_attachmentsTableModel.clearData();
        }
    }

    protected void preSetupLayout() {
        this.m_buttonPanel.setLayout(new FlowLayout(3, 0, 0));
        this.m_assignBtn = VWImageLoader.createToolBarButton("assign.gif", VWResource.s_assign, false);
        this.m_assignBtn.setRolloverEnabled(true);
        this.m_unassignBtn = VWImageLoader.createToolBarButton("unassign.gif", VWResource.s_unassign, false);
        this.m_unassignBtn.setRolloverEnabled(true);
        this.m_openBtn = VWImageLoader.createToolBarButton("open.gif", VWResource.s_open, false);
        this.m_openBtn.setRolloverEnabled(true);
        this.m_itemPropBtn = VWImageLoader.createToolBarButton("properties.gif", VWResource.s_assignedItemProperties, false);
        this.m_itemPropBtn.setRolloverEnabled(true);
        this.m_buttonPanel.add(this.m_assignBtn);
        this.m_buttonPanel.add(this.m_unassignBtn);
        this.m_buttonPanel.add(Box.createHorizontalStrut(4));
        this.m_buttonPanel.add(this.m_openBtn);
        this.m_buttonPanel.add(Box.createHorizontalStrut(4));
        this.m_buttonPanel.add(this.m_itemPropBtn);
        this.setLayout(new BorderLayout());
    }

    protected void setupLayout() {
        this.setupTablePane();
        this.add((Component)this.m_buttonPanel, "First");
        this.add((Component)this.m_tablePanel, "Center");
        this.updateButtonState();
        this.addActionListeners();
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    private void addActionListeners() {
        if (this.m_assignBtn != null) {
            this.m_assignBtn.addActionListener(this.m_assignActionListener);
        }
        if (this.m_miAssign != null) {
            this.m_miAssign.addActionListener(this.m_assignActionListener);
        }
        if (this.m_unassignBtn != null) {
            this.m_unassignBtn.addActionListener(this.m_unassignActionListener);
        }
        if (this.m_miUnassign != null) {
            this.m_miUnassign.addActionListener(this.m_unassignActionListener);
        }
        if (this.m_addBtn != null) {
            this.m_addBtn.addActionListener(this.m_addActionListener);
        }
        if (this.m_miAdd != null) {
            this.m_miAdd.addActionListener(this.m_addActionListener);
        }
        if (this.m_deleteBtn != null) {
            this.m_deleteBtn.addActionListener(this.m_deleteActionListener);
        }
        if (this.m_miDelete != null) {
            this.m_miDelete.addActionListener(this.m_deleteActionListener);
        }
        if (this.m_openBtn != null) {
            this.m_openBtn.addActionListener(this.m_openActionListener);
        }
        if (this.m_miOpen != null) {
            this.m_miOpen.addActionListener(this.m_openActionListener);
        }
        if (this.m_itemPropBtn != null) {
            this.m_itemPropBtn.addActionListener(this.m_itemPropActionListener);
        }
        if (this.m_miItemProp != null) {
            this.m_miItemProp.addActionListener(this.m_itemPropActionListener);
        }
        if (this.m_attachPropBtn != null) {
            this.m_attachPropBtn.addActionListener(this.m_attachPropActionListener);
        }
        if (this.m_miAttachProp != null) {
            this.m_miAttachProp.addActionListener(this.m_attachPropActionListener);
        }
        if (this.m_detailsBtn != null) {
            this.m_detailsBtn.addActionListener(this.m_detailsActionListener);
        }
        if (this.m_miDetails != null) {
            this.m_miDetails.addActionListener(this.m_detailsActionListener);
        }
    }

    protected void setupTablePane() {
        TableColumnModel columnModel = null;
        this.m_attachmentsTable = new VWTable(){

            public boolean editCellAt(int row, int column, EventObject e) {
                if (column == 2) {
                    if (e instanceof MouseEvent && ((MouseEvent)e).getClickCount() < VWStepAttachmentsPanel.this.m_fieldsCellEditor.getClickCountToStart()) {
                        return false;
                    }
                    if (!VWStepAttachmentsPanel.this.isEditable(true)) {
                        return false;
                    }
                }
                return super.editCellAt(row, column, e);
            }
        };
        this.m_attachmentsTable.setRowSelectionAllowed(true);
        this.m_attachmentsTable.setSelectionMode(0);
        this.m_attachmentsTable.setModel(this.m_attachmentsTableModel);
        columnModel = this.m_attachmentsTable.getColumnModel();
        TableColumn columnExpand = columnModel.getColumn(0);
        TableColumn columnName = columnModel.getColumn(1);
        TableColumn columnValue = columnModel.getColumn(2);
        columnExpand.setMinWidth(15);
        columnExpand.setMaxWidth(15);
        columnValue.setMinWidth(40);
        columnValue.setMinWidth(100);
        columnExpand.setCellRenderer(this.m_expandBtnRenderer);
        columnExpand.setCellEditor(this.m_expandBtnEditor);
        columnName.setCellRenderer(this.m_fieldNameRenderer);
        columnValue.setCellRenderer(this.m_fieldsCellRenderer);
        columnValue.setCellEditor(this.m_fieldsCellEditor);
        this.m_tablePanel = new JScrollPane(this.m_attachmentsTable);
        columnValue.sizeWidthToFit();
        this.m_attachmentsTable.addMouseListener(this);
    }

    protected void updateDisplay() {
        this.stopEditing();
        this.updateButtonState();
        this.m_attachmentsTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEditable(boolean bPrompt) {
        if (!this.isLiveData()) {
            return false;
        }
        if (bPrompt && !this.isDataEditable()) {
            try {
                if (this.m_lockStepDlg == null) {
                    this.m_lockStepDlg = this.m_bStepView ? new VWLockStepDialog(this.m_parentFrame, this.m_stepOccurrence) : new VWLockStepDialog(this.m_parentFrame, this.m_participant);
                    if (this.m_lockStepDlg != null && this.m_lockStepDlg.isAskAgain()) {
                        this.m_lockStepDlg.setVisible(true);
                    }
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
            finally {
                if (this.m_lockStepDlg != null) {
                    this.m_lockStepDlg.removeReferences();
                    this.m_lockStepDlg = null;
                }
            }
        }
        return this.isDataEditable();
    }

    public void createPopup(MouseEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JTable) || source != this.m_attachmentsTable) {
            return;
        }
        JTable table = (JTable)source;
        if (table.isEditing()) {
            table.removeEditor();
        }
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int col = table.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        this.m_editRow = row;
        this.m_editCol = col;
        this.m_editEvent = evt;
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        if (col == 2) {
            if (!this.isLiveData()) {
                return;
            }
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
                this.m_popup.add(this.m_miAssign);
                this.m_popup.add(this.m_miUnassign);
                this.m_popup.add(new JSeparator());
                this.m_popup.add(this.m_miOpen);
                this.m_popup.add(new JSeparator());
                this.m_popup.add(this.m_miItemProp);
            }
            this.m_popup.show(this.m_attachmentsTable, point.x, point.y);
        }
    }

    public void doubleClickedItem(MouseEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JTable) || source != this.m_attachmentsTable) {
            return;
        }
        JTable table = (JTable)source;
        if (table.isEditing()) {
            table.removeEditor();
        }
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int col = table.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        this.m_editRow = row;
        this.m_editCol = col;
        this.m_editEvent = evt;
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        if (col == 2) {
            if (!this.m_attachmentsTable.editCellAt(this.m_editRow, this.m_editCol, evt)) {
                return;
            }
            this.m_fieldsCellEditor.shouldSelectCell(new MouseEvent(this.m_attachmentsTable, this.m_editEvent.getID(), this.m_editEvent.getWhen(), this.m_editEvent.getModifiers(), this.m_editEvent.getX(), this.m_editEvent.getY(), 2, false));
        }
    }

    private void performAddAttachment() {
        if (!this.isEditable(true)) {
            return;
        }
        this.updateButtonState();
    }

    private void performAssignAttachment() {
        int row = this.m_attachmentsTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (!this.isEditable(true)) {
            return;
        }
        MouseEvent evt = new MouseEvent(this.m_attachmentsTable, 0, 0L, 0, 0, 0, 2, false);
        if (!this.m_attachmentsTable.editCellAt(row, 2, evt)) {
            return;
        }
        this.m_fieldsCellEditor.shouldSelectCell(evt);
        this.updateButtonState();
    }

    private void performDeleteAttachment() {
        int row = this.m_attachmentsTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (!this.isEditable(true)) {
            return;
        }
        this.m_attachmentsTableModel.removeAttachment(row);
        this.updateButtonState();
    }

    private void performUnassignAttachment() {
        int row = this.m_attachmentsTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (!this.isEditable(true)) {
            return;
        }
        try {
            this.m_attachmentsTableModel.unassignAttachment(row);
        }
        catch (Exception e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_parentFrame, e.getMessage(), VWResource.s_unassign, 0);
        }
        this.updateButtonState();
    }

    private void performAssignedItemProperties() {
        int row = this.m_attachmentsTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        try {
            this.m_attachmentsTableModel.assignedItemProperties(row);
        }
        catch (Exception e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_parentFrame, e.getMessage(), VWResource.s_assignedItemProperties, 0);
        }
    }

    private void performAttachmentProperties() {
        int row = this.m_attachmentsTable.getSelectedRow();
        if (row == -1) {
            return;
        }
    }

    private void performOpenAttachment() {
        int row = this.m_attachmentsTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        try {
            this.m_attachmentsTableModel.openAssignedAttachment(row);
        }
        catch (Exception e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_parentFrame, e.getMessage(), VWResource.s_openAssignedItem, 0);
        }
    }

    private void performDetails() {
    }

    private void updateButtonState() {
        if (this.m_attachmentsTable != null) {
            int row = this.m_attachmentsTable.getSelectedRow();
            boolean bEnable = false;
            bEnable = this.m_attachmentsTableModel.getCanAssign(row);
            if (this.m_assignBtn != null) {
                this.m_assignBtn.setEnabled(bEnable);
            }
            if (this.m_miAssign != null) {
                this.m_miAssign.setEnabled(bEnable);
            }
            bEnable = this.m_attachmentsTableModel.getCanUnassign(row);
            if (this.m_unassignBtn != null) {
                this.m_unassignBtn.setEnabled(bEnable);
            }
            if (this.m_miUnassign != null) {
                this.m_miUnassign.setEnabled(bEnable);
            }
            bEnable = this.m_attachmentsTableModel.getCanAdd(row);
            if (this.m_addBtn != null) {
                this.m_addBtn.setEnabled(bEnable);
            }
            if (this.m_miAdd != null) {
                this.m_miAdd.setEnabled(bEnable);
            }
            bEnable = this.m_attachmentsTableModel.getCanDelete(row);
            if (this.m_deleteBtn != null) {
                this.m_deleteBtn.setEnabled(bEnable);
            }
            if (this.m_miDelete != null) {
                this.m_miDelete.setEnabled(bEnable);
            }
            bEnable = this.m_attachmentsTableModel.getCanOpen(row);
            if (this.m_openBtn != null) {
                this.m_openBtn.setEnabled(bEnable);
            }
            if (this.m_miOpen != null) {
                this.m_miOpen.setEnabled(bEnable);
            }
            bEnable = this.m_attachmentsTableModel.getCanViewAttachProp(row);
            if (this.m_attachPropBtn != null) {
                this.m_attachPropBtn.setEnabled(bEnable);
            }
            if (this.m_miAttachProp != null) {
                this.m_miAttachProp.setEnabled(bEnable);
            }
            bEnable = this.m_attachmentsTableModel.getCanViewItemProp(row);
            if (this.m_itemPropBtn != null) {
                this.m_itemPropBtn.setEnabled(bEnable);
            }
            if (this.m_miItemProp != null) {
                this.m_miItemProp.setEnabled(bEnable);
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 701: {
                    this.updateButtonState();
                }
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (!this.m_bTableAdjusted) {
            this.m_attachmentsTable.updateUI();
            this.m_bTableAdjusted = true;
        }
        this.updateButtonState();
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.updateButtonState();
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    protected void stopEditing() {
        if (this.m_fieldsCellEditor != null) {
            this.m_fieldsCellEditor.stopCellEditing();
        }
    }

    public void removeReferences() {
        super.removeReferences();
        if (this.m_tablePanel != null) {
            this.m_tablePanel.removeAll();
            this.m_tablePanel = null;
        }
        if (this.m_attachmentsTable != null) {
            TableColumnModel columnModel = this.m_attachmentsTable.getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setCellRenderer(null);
                columnModel.getColumn(i).setCellEditor(null);
            }
            this.m_attachmentsTable.removeReferences();
            this.m_attachmentsTable = null;
        }
        if (this.m_attachmentsTableModel != null) {
            this.m_attachmentsTableModel.removeReferences();
            this.m_attachmentsTableModel = null;
        }
        if (this.m_detailsBtn != null) {
            this.m_detailsBtn.removeActionListener(this.m_detailsActionListener);
            this.m_detailsBtn = null;
        }
        if (this.m_openBtn != null) {
            this.m_openBtn.removeActionListener(this.m_openActionListener);
            this.m_openBtn = null;
        }
        if (this.m_itemPropBtn != null) {
            this.m_itemPropBtn.removeActionListener(this.m_itemPropActionListener);
            this.m_itemPropBtn = null;
        }
        if (this.m_attachPropBtn != null) {
            this.m_attachPropBtn.removeActionListener(this.m_attachPropActionListener);
            this.m_attachPropBtn = null;
        }
        if (this.m_addBtn != null) {
            this.m_addBtn.removeActionListener(this.m_addActionListener);
            this.m_addBtn = null;
        }
        if (this.m_deleteBtn != null) {
            this.m_deleteBtn.removeActionListener(this.m_deleteActionListener);
            this.m_deleteBtn = null;
        }
        if (this.m_unassignBtn != null) {
            this.m_unassignBtn.removeActionListener(this.m_unassignActionListener);
            this.m_unassignBtn = null;
        }
        if (this.m_assignBtn != null) {
            this.m_assignBtn.removeActionListener(this.m_assignActionListener);
            this.m_assignBtn = null;
        }
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_miAdd != null) {
            this.m_miAdd.removeActionListener(this.m_addActionListener);
            this.m_miAdd = null;
        }
        if (this.m_miDelete != null) {
            this.m_miDelete.removeActionListener(this.m_deleteActionListener);
            this.m_miDelete = null;
        }
        if (this.m_miOpen != null) {
            this.m_miOpen.removeActionListener(this.m_openActionListener);
            this.m_miOpen = null;
        }
        if (this.m_miItemProp != null) {
            this.m_miItemProp.removeActionListener(this.m_itemPropActionListener);
            this.m_miItemProp = null;
        }
        if (this.m_miAttachProp != null) {
            this.m_miAttachProp.removeActionListener(this.m_attachPropActionListener);
            this.m_miAttachProp = null;
        }
        if (this.m_miUnassign != null) {
            this.m_miUnassign.removeActionListener(this.m_unassignActionListener);
            this.m_miUnassign = null;
        }
        if (this.m_miAssign != null) {
            this.m_miAssign.removeActionListener(this.m_assignActionListener);
            this.m_miAssign = null;
        }
        if (this.m_miDetails != null) {
            this.m_miDetails.removeActionListener(this.m_detailsActionListener);
            this.m_miDetails = null;
        }
        this.m_assignActionListener = null;
        this.m_unassignActionListener = null;
        this.m_addActionListener = null;
        this.m_deleteActionListener = null;
        this.m_openActionListener = null;
        this.m_itemPropActionListener = null;
        this.m_attachPropActionListener = null;
        this.m_detailsActionListener = null;
        if (this.m_lockStepDlg != null) {
            this.m_lockStepDlg.removeReferences();
            this.m_lockStepDlg = null;
        }
        this.m_expandBtnRenderer = null;
        this.m_expandBtnEditor = null;
        this.m_fieldNameRenderer = null;
        this.m_fieldsCellRenderer = null;
        this.m_fieldsCellEditor = null;
        if (this.m_buttonPanel != null) {
            this.m_buttonPanel.removeAll();
            this.m_buttonPanel = null;
        }
        this.m_editEvent = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.removeAll();
    }
}

